RequireSystemScript("math.js");

function game() {
	SetFrameRate(60);
	var Game = new _Canasta();
	while (!IsKeyPressed(KEY_ESCAPE)) {
		Game.handle();
		FlipScreen();
	}
}

function _Canasta() {
	this.mouse = LoadImage("mouse.png");
	this.arrow = LoadImage("arrow.png");
	this.backGraphic = LoadImage("backdiastripes2.png");
	this.backGraphicHor = LoadImage("sideways/backdiastripes2.png");
	this.font = LoadFont("font.rfn");
	this.stock = { x: 444, y: 250, cards: [] };
	this.discardPile = { x: 504, y: 250, cards: [] }
	this.players = [];
	for (var i = 0; i < 4; i++) {
		this.players[i] = { hand: [], foot: [], x: 0, y: 0, team: 0 }
	}
	this.players[0].x = 499; this.players[0].y = 600;
	this.players[1].x = 80; this.players[1].y = 349; this.players[1].team = 1;
	this.players[2].x = 454; this.players[2].y = 1;
	this.players[3].x = 919; this.players[3].y = 349; this.players[3].team = 1;
	this.reset();
	this.canastaPoints = [ [0,0,0,0,0], [0,0,0,0,0] ];
	this.cardPoints = [ [0,0,0,0,0], [0,0,0,0,0] ];
	this.points = [ [0,0,0,0,0], [0,0,0,0,0] ];
	this.log = OpenLog("log.txt");
	this.cards = _setCards(); 
	
	this.keys = { mouse: [], shift: false, score: false, discard: false, wild: false, last: 0, delay: 60 };
	this.phase = "draw";
	this.whoStarts = getRandom(0,3); this.turn = this.whoStarts;
	this.hands = [50, 90, 120, 150, 200];
	this.currentHand = 0;
	this.hightLight = { card: -1, indicate: -1 };
	this.animateLength = 60;
	this.animateExtra = -1;
	
	this.color = { black: CreateColor(0,0,0), indicateTint: CreateColor(240,240,0,180), shiftTint: CreateColor(110,110,0,180),
		white: CreateColor(255,255,255), lightGreen: CreateColor(0,220,0), orange: CreateColor(255,128,0), grey: CreateColor(80,80,80),
		yellow: CreateColor(168,168,0), redTint: CreateColor(200, 0, 0,150), yellow2: CreateColor(168,168,0, 80) };
	
	this.debug = false;
	this.debugText = "";
	this.debugInfo = [];
	this.aiLogic = { discard: false, drawn: false, debug: 0, options: [] };
	this.aiLogic.options.push("startWild","finishWild","finishMeld","prepareOut","addMeld","newMeld","dumpWildFoot","tuck","goFoot","addWild","dumpWildHand");
	
	this.team = [];
		this.team.push({ tableX: 270, tableY: 410, meldX: 35, meldY: 20, canastaX: 378, canastaY: 100, can: 25, red3X: 300, red3Y: 100 }) //475
		this.team.push({ tableX: 190, tableY: 180, meldX: -20, meldY: 35, canastaX: 797, canastaY: 445, can: -25, red3X: 797, red3Y: 538 })
		
	this.game = { cardX: 20, cardY: 20, discardsAboveUser: 520, cardWidth: 50, cardHeight: 70 } //extra options. //660
}

_Canasta.prototype.handle = function() {
	this.render();
	this.keyHandle();
	if (this.phase == "finishHand" && this.animateList.length == 0) {
		this.showScore();
		if (IsKeyPressed(KEY_ENTER) && this.currentHand != 4) { 
			this.reset();
			this.currentHand++;
			if (this.whoStarts == 3) { this.turn = 0; this.whoStarts = 0; }
			else { this.whoStarts++; this.turn = this.whoStarts; }
			this.phase = "draw"; 
		}
	}
	else if(this.phase == "done" && this.animateList.length == 0) {
		if (this.turn == 3) { 
			this.turn = 0; 
			this.phase = "draw";
		}
		else { 
			this.turn++; 
			this.phase = "";
			this.aiLogic.drawn = false;
			this.aiLogic.discard = false;
		}
	}
	else {
		if (this.turn == 0) { this.userTurn(); }
		else { 
			if (this.phase != "wait") { this.ai(this.turn, this.players[this.turn].team); }
		}
	}
	this.keys.last++;
}

_Canasta.prototype.render = function() {
	this.showTable();
	this.userHand(); 
	this.showArrow();
	if (this.keys.score && !this.debug) { this.showScore(); }
	if (this.phase == "wild" && this.turn == 0) { this.burnWild(); }
	if (this.animateList.length > 0) { this.animate(); }
	else { 
		if (this.animateQuery > 0) { 
			var animate = this.animateQuery.shift();
			this.animateList.push(new _animate(animate.x, animate.y, animate.x2, animate.y2, animate.image, animate.action, animate.iterations, animate.team, animate.nextPhase));
		}
	}
	for (var i = 0; i < this.debugInfo.length; i++) { this.font.drawText(600, 160 + (i * 10), this.debugInfo[i]); }
	if (this.debug) { this.font.drawText(600, 150, this.debugText); }
	
	this.mouse.blit(GetMouseX(), GetMouseY());
}

_Canasta.prototype.keyHandle = function() {
	var x = GetMouseX(); var y = GetMouseY();
	this.keys.shift = false; this.keys.discard = false; this.keys.wild = false; this.keys.score = false;
	if (IsKeyPressed(KEY_S) && !this.debug) { this.keys.score = true; }
	if (IsKeyPressed(KEY_SHIFT) && !this.debug) { this.keys.shift = true; }
	if (IsKeyPressed(KEY_CTRL) && !this.debug) { this.keys.wild = true; }
	if (IsKeyPressed(KEY_ALT) && !this.debug) { //discarding...
		if (this.phase == "discards" && !this.melded[0]) { //picking up discards, not melded...
			if (this.checkMeldPoints()) {
				this.melded[0] = true;
				if (this.table[0][this.cards[this.discardPile.cards[0]].card].length > 1) { //pair is already done, no need to summon it.
					var card = this.discardPile.cards.shift();
					var tableX = this.team[0].tableX + (this.cards[card].card * this.team[0].meldX);
					var tableY = this.team[0].tableY + (this.table[0][this.cards[card].card].length * this.team[0].meldY);
					this.animateList.push(new _animate([this.discardPile.x], [this.discardPile.y], [tableX], [tableY], card, "table", this.animateLength, 1));
				}
				else { //pair is still in hand...
					var location = this.findCard(0,this.cards[this.discardPile.cards[0]].card);
					var cards = [this.players[0].hand[location], this.players[0].hand[(location+1)]];
					var tableX = this.team[0].tableX + (this.cards[cards[0]].card * this.team[0].meldX);
					var tableY = this.team[0].tableY + (this.table[0][this.cards[cards[0]].card].length * this.team[0].meldY);
					this.animateList.push(new _animate([this.discardPile.x],[this.discardPile.y],[tableX],[tableY],[this.discardPile.cards[0]],"table",this.animateLength,1));
					this.animateList.push(new _animate([this.players[0].x,this.players[0].x],[this.players[0].y,this.players[0].y+this.game.cardX],[tableX, tableX],[(tableY+this.game.cardY),(tableY + (this.game.cardY*2))],[cards[0],cards[1]],"table",this.animateLength,2));
					this.players[0].hand.splice(location, 2);
					this.discardPile.cards.shift();
				}
				//add discard pile to hand...
				var position = this.discardPile.cards.length * 7.5;
				var pile = { x: [], y: [], x2: [], y2: [], image: [] };
				for (var i = 0; i < this.discardPile.cards.length; i++) {
					pile.x.push(this.discardPile.x); pile.y.push(this.discardPile.y);
					pile.x2.push((this.players[0].x - position) + (i * 15));
					pile.y2.push(this.game.discardsAboveUser); pile.image.push(this.discardPile.cards[i]);
				}
				this.animateList.push(new _animate(pile.x,pile.y,pile.x2,pile.y2,pile.image,"nil",this.animateLength,this.discardPile.cards.length));
				this.animateList.push(new _animate(pile.x2,pile.y2,pile.x2,pile.y2,pile.image,"hand",this.animateLength,this.discardPile.cards.length));
				this.discardPile.cards = [];
				this.phase = "play";
			}
			else { //didn't have enough points to meld...
				for (var i = 0; i < this.table[0].length; i++) {
					for (var j = 0; j < this.table[0][i].length; j++) {
						if (this.table[0][i][j] != undefined) { this.players[0].hand.push(this.table[0][i][j]); }
					}
					this.table[0][i] = [];
				}
				this.players[0].hand.sort(compareNumbers);
			}
		}
		else if (this.phase == "wild") { //return wild to hand..
			this.players[0].hand.push(this.animateExtra);
			this.players[0].hand.sort(compareNumbers);
			this.checkCanasta(0);
			this.phase = "play";
		}
		else { 
			if (this.checkMeldPoints()) { this.melded[0] = true; this.checkCanasta(0); }
			for (var i = 0; i < this.table[0].length; i++) {
				if (this.table[0][i].length < 3 || !this.melded[0]) { 
					for (var j = 0; j < this.table[0][i].length; j++) { this.players[0].hand.push(this.table[0][i][j]); }
					this.table[0][i] = [];
				}
			}
			this.players[0].hand.sort(compareNumbers);
			this.keys.discard = true; 
		}
	}
	if (IsMouseButtonPressed(MOUSE_RIGHT) && this.keys.last > this.keys.delay && !IsKeyPressed(KEY_SHIFT)) {
		for (var i = 0; i < this.keys.mouse.length; i++){
			if (x > this.keys.mouse[i].x && x < this.keys.mouse[i].x2 && y > this.keys.mouse[i].y && y < this.keys.mouse[i].y2) {
				this.keys.last = 0;
				var location = this.keys.mouse[i].extra;
				var card = this.cards[this.players[0].hand[location]].card;
				if (this.players[0].hand.length > 1 || this.players[0].foot.length != 0) { //at least leaving a discard.
					for (var j = 0; j < this.canastas[0].length; j++) {
						if (this.cards[this.canastas[0][j]].card == card) {
							var pile = { x: [(this.players[0].x - (this.players[0].hand.length*7.5) + (location * 15))], y: [this.players[0].y], x2: [(this.team[0].canastaX + (j * this.team[0].can))], y2: [this.team[0].canastaY], image: [this.players[0].hand[location]] };
							this.animateList.push(new _animate(pile.x,pile.y,pile.x2,pile.y2,pile.image,"tuck",this.animateLength, pile.x.length));
							this.players[0].hand.splice(location, 1);
							break;
						}
					}
				}
			}
		}
	}
	if (IsMouseButtonPressed(MOUSE_LEFT) && this.keys.last > this.keys.delay) {
		for (var i = 0; i < this.keys.mouse.length; i++) {
			if (x > this.keys.mouse[i].x && x < this.keys.mouse[i].x2 && y > this.keys.mouse[i].y && y < this.keys.mouse[i].y2) {
				this.keys.last = 0;
				switch (this.keys.mouse[i].id) {
					case "wild": {
						this.table[0][this.keys.mouse[i].extra].push(this.animateExtra);
						this.checkCanasta(0);
						this.phase = "play";
						break;
					}
					case "discards": {
						if (this.checkPair(0)) {
							if (this.melded[0]) {
								var location = this.findCard(0, this.cards[this.discardPile.cards[0]].card);
								var cards = [this.players[0].hand[location], this.players[0].hand[(location+1)]];
								var tableX = this.team[0].tableX + (this.cards[cards[0]].card * this.team[0].meldX);
								var tableY = this.team[0].tableY + (this.table[0][this.cards[cards[0]].card].length * this.team[0].meldY);
								this.animateList.push(new _animate([this.discardPile.x],[this.discardPile.y],[tableX],[tableY],[this.discardPile.cards[0]],"table",this.animateLength,1));
								this.discardPile.cards.shift();
								this.animateList.push(new _animate([this.players[0].x,this.players[0].x+this.game.cardX],[this.players[0].y,this.players[0].y],[tableX, tableX],[(tableY+this.game.cardY),(tableY + (this.game.cardY*2))],[cards[0],cards[1]],"table",this.animateLength,2));
								this.players[0].hand.splice(location, 2);
								var position = this.discardPile.cards.length * 7.5;
								var pile = { x: [], y: [], x2: [], y2: [], image: [] };
								for (var j = 0; j < this.discardPile.cards.length; j++) {
									pile.x.push(this.discardPile.x); pile.y.push(this.discardPile.y);
									pile.x2.push((this.players[0].x-position) + (j * 15)); pile.y2.push(this.game.discardsAboveUser);
									pile.image.push(this.discardPile.cards[j]);
								}
								this.animateList.push(new _animate(pile.x,pile.y,pile.x2,pile.y2,pile.image,"nil",this.animateLength,this.discardPile.cards.length));
								this.animateList.push(new _animate(pile.x2,pile.y2,pile.x2,pile.y2,pile.image,"hand",this.animateLength,this.discardPile.cards.length));
								this.discardPile.cards = [];
								this.phase = "play";
							}
							else { this.phase = "discards"; }
						}
						else { this.phase = "draw"; }
						break;
					}
					case "stock": {
						var pickUp = [];
						if (this.stock.cards.length > 0) { pickUp.push(this.stock.cards.pop()); }
						if (this.stock.cards.length > 0) { pickUp.push(this.stock.cards.pop()); }
						if (pickUp.length == 2) {
							this.animateList.push(new _animate([this.stock.x,this.stock.x+this.game.cardX],[this.stock.y,this.stock.y+this.game.cardY],[this.players[0].x,this.players[0].x+this.game.cardX],[this.game.discardsAboveUser,this.game.discardsAboveUser],[99,99], "nil", 	this.animateLength, 2));
							this.animateList.push(new _animate([this.players[0].x,this.players[0].x+this.game.cardX],[this.game.discardsAboveUser,this.game.discardsAboveUser],[this.players[0].x,this.players[0].x+this.game.cardX],[this.game.discardsAboveUser,this.game.discardsAboveUser],pickUp, 	"hand", this.animateLength, 2));
						}
						else if (pickUp.length == 1) {
							this.animateList.push(new _animate([this.stock.x],[this.stock.y],[this.players[0].x],[this.game.discardsAboveUser],[99],"nil", this.animateLength, 1));
							this.animateList.push(new _animate([this.players[0].x],[this.game.discardsAboveUser],[this.players[0].x],[this.game.discardsAboveUser],pickUp,"hand", this.animateLength, 1));
						}
						this.phase = "play";
						break;
					}
					case 13: {//black threes
						if (this.phase != "discards") {
							this.animateList.push(new _animate([this.keys.mouse[i].x],[this.keys.mouse[i].y],[this.discardPile.x],[this.discardPile.y],[this.players[0].hand[this.keys.mouse[i].extra]],"discard", this.animateLength, 1));
							this.players[0].hand.splice(this.keys.mouse[i].extra, 1);
							if (!this.melded[0]) {
								if (this.checkMeldPoints()) { this.melded[0] = true; }
								else { 
									for (var k = 0; k < this.table[0].length; k++) {
										for (var j = 0; j < this.table[0][k].length; j++) {
											if (this.table[0][k][j] != undefined) { this.players[0].hand.push(this.table[0][k][j]); }
										}
										this.table[0][k] =[];
									}
								}
							}
							for (var k = 0; k < this.table[0].length; k++) {
								if (this.table[0][k].length < 3 && this.table[0][k].length > 0) { 
									for (var j = 0; j < this.table[0][k].length; j++) { this.players[0].hand.push(this.table[0][k][j]); }
									this.table[0][k] = [];
								}
							}
							this.phase = "done";
						}
						break;
					}
					case 12: { //red threes
						this.animateList.push(new _animate([this.keys.mouse[i].x],[this.keys.mouse[i].y],[this.team[0].red3X],[this.team[0].red3Y], [this.players[0].hand[this.keys.mouse[i].extra]], "red3", this.animateLength - 20, 1));
						this.players[0].hand.splice(this.keys.mouse[i].extra, 1);
						this.canastaPoints[0][this.currentHand] += 100;
						if (this.stock.cards.length > 0) { 
							var extra = this.stock.cards.pop();
							this.animateList.push(new _animate([this.stock.x],[this.stock.y],[this.players[0].x],[this.game.discardsAboveUser],[99],"nil", this.animateLength - 20, 1));
							this.animateList.push(new _animate([this.players[0].x],[this.game.discardsAboveUser],[this.players[0].x],[this.game.discardsAboveUser],[extra],"hand", this.animateLength, 1));
						}
						break;
					}
					default: {
						var card = this.cards[this.players[0].hand[this.keys.mouse[i].extra]].card;
						if (!this.keys.wild && this.keys.shift && this.removeAndAble(0, card, card, this.findAmount(0,card))) {
							var pile = { x: [], y: [], x2: [], y2: [], image: [] };
							var location = this.findCard(0,card);
							for (var j = 0; j < this.findAmount(0,card); j++) {
								pile.x.push((this.players[0].x - (this.players[0].hand.length*7.5) + (location * 15) + (j*15)));
								pile.y.push(this.players[0].y);  pile.x2.push((card * this.team[0].meldX) + this.team[0].tableX);
								pile.y2.push(((this.table[0][card].length * this.team[0].meldY) + (j * this.team[0].meldY) + this.team[0].tableY));
								pile.image.push(this.players[0].hand[(location+j)]);
							}
							this.animateList.push(new _animate(pile.x,pile.y,pile.x2,pile.y2,pile.image,"table",this.animateLength, pile.x.length));
							this.players[0].hand.splice(location, pile.x.length);
						}
						else if (this.keys.discard && !this.keys.wild) {
							this.animateList.push(new _animate([this.keys.mouse[i].x],[this.keys.mouse[i].y],[this.discardPile.x],[this.discardPile.y],[this.players[0].hand[this.keys.mouse[i].extra]],"discard", this.animateLength, 1));
							this.players[0].hand.splice(this.keys.mouse[i].extra, 1);
							if (!this.melded[0]) {
								if (this.checkMeldPoints()) { this.melded[0] = true; }
								else { 
									for (var k = 0; k < this.table[0].length; k++) {
										for (var j = 0; j < this.table[0][k].length; j++) {
											if (this.table[0][k][j] != undefined) { this.players[0].hand.push(this.table[0][k][j]); }
										}
										this.table[0][k] = [];
									}
								}
							}
							for (var k = 0; k < this.table[0].length; k++) {
								if (this.table[0][k].length < 3 && this.table[0][k].length > 0) { 
									for (var j = 0; j < this.table[0][k].length; j++) { this.players[0].hand.push(this.table[0][k][j]); }
									this.table[0][k] = [];
								}
							}
							this.phase = "done";
						}
						else if (this.keys.wild && this.cards[this.players[0].hand[this.keys.mouse[i].extra]].card == 11) {
							this.animateExtra = this.players[0].hand[this.keys.mouse[i].extra];
							this.players[0].hand.splice(this.keys.mouse[i].extra, 1);
							this.phase = "wild";
						}
						else { // play just a single card
							if (!this.keys.wild && this.removeAndAble(0, card, card, 1)) {
								var x2 = (this.cards[this.players[0].hand[this.keys.mouse[i].extra]].card * this.team[0].meldX) + this.team[0].tableX;
								var y2 = (this.table[0][this.cards[this.players[0].hand[this.keys.mouse[i].extra]].card].length * this.team[0].meldY) + this.team[0].tableY;
								var card = this.players[0].hand[this.keys.mouse[i].extra];
								this.animateList.push(new _animate([this.keys.mouse[i].x],[this.keys.mouse[i].y],[x2],[y2],[card],"table",this.animateLength,1));
								this.players[0].hand.splice(this.keys.mouse[i].extra, 1);
							}
						}
						break;
					}
				}
				this.keys.last = 0;
			}
		}
	}
	if (this.phase != "wild" && this.players[0].hand.length == 0 && this.melded[0] && this.players[0].foot.length > 0 && this.phase != "discards") { 
		var legal = true;
		for (var j = 0; j < this.table[0].length; j++) {
			if (this.table[0][j].length == 2 || this.table[0][j].length == 1) { legal = false; }
		}
		if (legal) {
			for (var j = 0; j < this.players[0].foot.length; j++) { this.players[0].hand.push(this.players[0].foot[j]); }
			this.players[0].foot = [];
		}
	}
	else if (this.phase != "finishHand" && this.phase != "wild" && this.players[0].hand.length == 0 && this.melded[0] && this.players[0].foot.length == 0 && this.phase != "discards") {
		this.changeHand(0);
		this.phase = "finishHand";
	}
	this.players[0].hand.sort(compareNumbers);
	while (AreKeysLeft()) {
		var key = GetKey();
		if (this.debug) {
			switch(key) {
				case (KEY_BACKSPACE): {
					if (this.debugText != "") { this.debugText = this.debugText.substring(0, this.debugText.length - 1); }
					break;  
				}
				case (KEY_ENTER): {
					if (this.debugText == "this.") { this.debug = false; }
					else if (this.debugText != "")  {
						this.debugInfo.push(this.debugText + " = " + eval(this.debugText));
						if (this.debugInfo.length > 20) { this.debugInfo.shift(); }
					}
					this.debug = false;
					break;
				}
				default: { this.debugText += GetKeyString(key, IsKeyPressed(KEY_SHIFT)); }
			}
		}
		else {
			switch(key) {
				case (KEY_TILDE): {
					this.debug = true;
					break;
				}
			}
		}
	}
}

_Canasta.prototype.ai = function(turn, team) {
	if (!this.aiLogic.drawn) {
		//add condition so it won't unnessarily wanna pick up discards when trying to go out.
		if ((this.melded[team] && this.checkPair(turn) && this.discardPile.cards.length > 9) || (this.stock.cards.length == 0 && this.checkPair(turn) && this.melded[team])) {
			var position = this.findCard(turn, this.cards[this.discardPile.cards[0]].card);
			var cards = [this.discardPile.cards.shift(), this.players[turn].hand[position], this.players[turn].hand[position+1]];
			var tableX = team == 0 ? this.team[0].tableX + (this.cards[cards[0]].card * this.team[0].meldX) : this.team[1].tableX - (this.table[1][this.cards[cards[0]].card].length * this.team[1].meldX);
			var tableY = team == 0 ? this.team[0].tableY + (this.table[0][this.cards[cards[0]].card].length * this.team[0].meldY) : this.team[1].tableY + (this.cards[cards[0]].card * this.team[1].meldY);
			this.animateList.push(new _animate([this.players[turn].x, this.players[turn].x, this.discardPile.x],[this.players[turn].y, (this.players[turn].y+this.game.cardX), this.discardPile.y], [tableX,tableX,tableX],[tableY,(tableY+this.game.cardY),(tableY+(this.game.cardY*2))],cards,"aiTable", this.animateLength,3,turn,"aiDiscardPile"));
			this.players[turn].hand.splice(position,2);
			this.players[turn].hand.sort(compareNumbers);
			this.aiLogic.drawn = true;
			this.aiLogic.debug = "pickup discard pile";
		}
		else if(this.stock.cards.length > 0) { //pick up cards, if available...
			var take = [];
			if (this.stock.cards.length > 0) { take.push(this.stock.cards.pop()); }
			if (this.stock.cards.length > 0) { take.push(this.stock.cards.pop()); }
			if (take.length > 1) { this.animateList.push(new _animate([this.stock.x,this.stock.x+5],[this.stock.y,this.stock.y+5],[this.players[turn].x,this.players[turn].x+5],[this.players[turn].y,this.players[turn].y],take,"aiHand",this.animateLength,2,turn,"red3")); }
			else if (take.length == 1) { this.animateList.push(new _animate([this.stock.x],[this.stock.y],[this.players[turn].x],[this.players[turn].y],take,"aiHand",this.animateLength,1,team,"red3")); }
			this.aiLogic.drawn = true;
			this.aiLogic.debug = "pick up cards";
		}
		else {  //end hand
			this.changeHand(-1);
			this.phase = "finishHand"; 
		} //end hand
	}
	else {
		if (this.red3(turn)) {
			var location = this.findRed3(turn);
			if(this.stock.cards.length > 0) {
				this.animateList.push(new _animate([this.players[turn].x],[this.players[turn].y],[this.team[team].red3X],[this.team[team].red3Y],[this.players[turn].hand[location]],"aiRed3",this.animateLength,1,team,"wait"));
				var card = this.stock.cards.pop();
				this.animateList.push(new _animate([this.stock.x],[this.stock.y],[this.players[turn].x],[this.players[turn].y],[card],"aiHand",this.animateLength,1,turn,"wait")); 
			}
			else { this.animateList.push(new _animate([this.players[turn].x],[this.players[turn].y],[this.team[team].red3X],[this.team[team].red3Y],[this.players[turn].hand[location]],"aiRed3",this.animateLength,1,team,"wait")); }
			
			this.players[turn].hand.splice(location, 1);
			this.players[turn].hand.sort(compareNumbers);
			this.aiLogic.debug = "red3";
		}
		else { //no red 3's, play in hand.
			if (this.melded[team]) {
				var action = false;
				for (var i = 0; i < this.aiLogic.options.length; i++) { 
					action = this.canAI(turn,team,this.aiLogic.options[i]);
					if (action) { break; }
				}
				if (action) { 
					var pile = { x: [], y: [], x2: [], y2: [], cards: [] };
					for (var i = 0; i < action.what.length; i++) { 
						if (action.where != "tuck") {
							var X = team == 0 ? this.team[0].tableX + (action.where*this.team[0].meldX) : (this.team[1].tableX + (this.table[1][action.where].length * this.team[1].meldX)+(i*this.team[1].meldX));
							var Y = team == 0 ? this.team[0].tableY + (this.table[0][action.where].length*this.team[0].meldY)+(i*this.team[0].meldY) : this.team[1].tableY + (action.where*this.team[1].meldY);
						}
						else { var X = this.team[team].canastaX; var Y = this.team[team].canastaY; }
						pile.x.push(this.players[turn].x); pile.y.push(this.players[turn].y); pile.x2.push(X); pile.y2.push(Y);
						pile.cards.push(action.what[i]);
					}
					this.animateList.push(new _animate(pile.x,pile.y,pile.x2,pile.y2,pile.cards,"aiPlayTable",this.animateLength,pile.x.length,team,"",action.where));
					for (var i = 0; i < action.what.length; i++) { 
						this.removeCard(turn, action.what[i]);
					}
				}
				else { this.findDiscard(turn); }
			}
			else { //try and meld.
				this.aiLogic.debug = "try to meld";
				var doCheck = this.checkAiMeldPoints(turn);
				var possibleMeldPoints = doCheck[0];
				var cardAmount = doCheck[1];	
				var cardLocation = doCheck[2];
				if (possibleMeldPoints >= this.hands[this.currentHand]) {
					decided = true;
					var cards = [];
					for (var i = 0; i < cardAmount.length; i++) {
						if (cardAmount[i] > 2) { //enough for a meld
							var pile = { x: [], y: [], x2: [], y2: [], image: [] };
							var X = team == 0 ? this.team[0].tableX + (i*this.team[0].meldX) : this.team[1].tableX;
							var Y = team == 0 ? this.team[0].tableY : this.team[1].tableY + (i*this.team[1].meldY);
							var xMove = team.index == 0 ? 0 : (this.team[1].meldX);
							var yMove = team.index == 0 ? this.team[0].meldY : 0;
							for (var j = 0; j < cardAmount[i]; j++) {
								pile.x.push(this.players[turn].x); pile.y.push(this.players[turn].y);
								pile.x2.push(X+(j*xMove)); pile.y2.push(Y+(j*yMove));
								pile.image.push(this.players[turn].hand[(cardLocation[i]+j)]);
								cards.push(this.players[turn].hand[(cardLocation[i]+j)]);
							}
							this.animateList.push(new _animate(pile.x,pile.y,pile.x2,pile.y2,pile.image,"aiTable",this.animateLength,pile.x.length,team,"wait"));
						}
					}
					for (var i = 0; i < cards.length; i++) { 
						this.removeCard(turn, cards[i]);
					}
					this.melded[team] = true;
				}
				else { this.findDiscard(turn); }
			}
		}
	}
	this.phase = "wait";
}

_Canasta.prototype.canAI = function(who, team, option) {
	var decide = false; var cards = [];
	//"startWild","finishWild","finishMeld","prepareOut","addMeld","newMeld","dumpWildFoot","tuck","goFoot","addWild","dumpWildHand"
	if (this.players[who].hand.length > 1 || this.players[who].foot.length) {
		switch(option) {
			case "startWild": {
				if (this.ableOut[team].wild && this.findAmount(who,11) == 3 && this.players[who].foot.length > 0 && (this.players[who].hand.length == 3 || this.players[who].hand.length == 4)) { 
					cards.push(this.players[who].hand[this.findCard(who,11)], this.players[who].hand[this.findCard(who,11)+1], this.players[who].hand[this.findCard(who,11)+2]);
					decide = { what: cards, where: 11 };
				}
				else if (this.findAmount(who, 11) > 2 && this.removeAndAble(who, 11, 11, 3)) { 
					cards.push(this.players[who].hand[this.findCard(who,11)], this.players[who].hand[this.findCard(who,11)+1], this.players[who].hand[this.findCard(who,11)+2]);
					decide = { what: cards, where: 11 };
				}
				break;
			}
			case "finishWild": {
				if (this.table[team][11].length > 0 && this.findAmount(who,11) > 0) {
					var left = 7 - this.table[team][11].length;
					if (this.findAmount(who,11) >= left && this.removeAndAble(who,11,11,left)) {
						for (var i = 0; i < left; i++) { cards.push(this.players[who].hand[this.findCard(who,11)+i]); }
						decide = { what: cards, where: 11 };
					}
				}
				break;
			}
			case "finishMeld": {
				var found = false;
				for (var i = 0; i < 11; i++) {
					if (this.table[team][i].length > 0) {
						var left = 7 - this.table[team][i].length; 
						if (!found && this.findAmount(who,i) >= left && this.removeAndAble(who,i,i,left)) {
							for (var j = 0; j < left; j++) { cards.push(this.players[who].hand[this.findCard(who,i)+j]); }
							decide = { where: i, what: cards };
							found = true;
						}
					}
				}
				break;
			}
			case "prepareOut": { 
				var otherTeam = team == 0 ? 1 : 0; 
				var opponents = team == 0 ? [1,3] : [0,2];
				var mate = team == 0 ? who == 0 ? 2 : 0 : who == 1 ? 3 : 1;
				if (this.findAmount(who, 11) > 0) {
					if (this.ableToGoOut(otherTeam) && (!this.ableOut[team].wild && !this.ableOut[team].black && !this.ableOut[team].red) && this.players[opponents[0]].foot.length == 0 && this.players[opponents[1]].foot.length == 0) {
						var best = { most: -1, where: 0 };
						for (var i = 0; i < 11; i++) {
							if (this.table[team][i].length > best.most && this.table[team][i].length != 0 && (this.table[team][i].length + this.findAmount(who,11)) >= 7) { 
								best.where = i; best.most = this.table[team][i].length;
							}
						}
						if (best.most != -1) {
							var left = 7 - best.most;
							if (this.removeAndAble(who, 11, best.where, left)) {
								for (var i = 0; i < left; i++) { cards.push(this.players[who].hand[this.findCard(who,11)+i]); }
								decide = { what: cards, where: best.where };
							}
						}
					}
					else if (this.ableOut[team].wild && this.ableOut[team].red && !this.ableOut[team].black && this.players[who].foot.length == 0 && this.players[mate].foot.length == 0) {
						var best = { most: -1, where: 0 };
						for (var i = 0; i < 11; i++) {
							if (this.table[team][i].length > best.most && this.table[team][i].length != 0) { 
								best.where = i; best.most = this.table[team][i].length;
							}
						}
						if (best.most != -1) {
							var left = 7 - best.most;
							if (this.findAmount(who, 11) >= (7-best.most) && this.removeAndAble(who,11,best.where,left)) {
								for (var i = 0; i < left; i++) { cards.push(this.players[who].hand[this.findCard(who,11)+i]); }
								decide = { what: cards, where: best.where };
							}
						}
					}
				}
				break;
			}
			case "addMeld": {
				var found = false;
				for (var i = 0; i < 11; i++) {
					if (!found && this.table[team][i].length > 0 && this.findAmount(who, i) > 0 && this.removeAndAble(who,i,i,1)) { 
						found = true;
						for (var j = 0; j < this.findAmount(who,i); j++) {
							if (this.removeAndAble(who, i, i, j)) { cards.push(this.players[who].hand[this.findCard(who, i) + j]); }
						}
						decide = { where: i, what: cards };
					}
				}
				break;
			}
			case "tuck": {
				if ((this.ableToGoOut(team) && this.players[who].hand.length > 1) || this.players[who].hand.length > 2 || this.players[who].foot.length > 0) {
					var found = false;
					for (var i = 0; i < this.canastas[team].length; i++) {
						var card = this.cards[this.canastas[team][i]].card;
						if (!found && this.findAmount(who, card) > 0 && card != 11) {
							found = true;
							cards.push(this.players[who].hand[this.findCard(who, card)]);
							decide = { where: "tuck", what: cards };
						}
					}
				}
				break;
			}
			case "newMeld": {
				var found = false;
				for (var i = 0; i < 11; i++) {
					if (!found && this.table[team][i].length == 0 && this.findAmount(who, i) > 2 && this.removeAndAble(who, i, i, 3)) {
						found = true;
						cards.push(this.players[who].hand[this.findCard(who, i)], this.players[who].hand[this.findCard(who,i)+1],this.players[who].hand[this.findCard(who,i)+2]);
						if (this.findAmount(who, i) > 3) {
							var start = 3;
							for (var j = 0; j < (this.findAmount(who,i) - 3); j++) { 
								if (this.removeAndAble(who, i, i, (j + start))) { cards.push(this.players[who].hand[this.findCard(who,i)+(start+j)]); }//0,1,2
							}
						}
						decide = { what: cards, where: i };
					}
				}
				break;
			}
			case "goFoot": {
				if (this.players[who].foot.length > 0 && this.findAmount(who, 13) < 2) { 
					var singles = 0; var pairs = 0; var whatPair = [];
					for (var i = 0; i < 11; i++) {
						if (this.findAmount(who,i) == 1) { singles++; }
						if (this.findAmount(who,i) == 2) { pairs++; whatPair.push(i); }
					}
					if (pairs < 3 && pairs > 0 && ((singles == 1 && this.findAmount(who,13) == 0) || (singles == 0 && this.findAmount(who, 13) == 1))) {
					//max possible: 1 single or 1 black 3, 2 pairs, 2 wilds
						if (this.findAmount(who,11) > 0 && this.findAmount(who,11) >= pairs) {
							cards.push(this.players[who].hand[this.findCard(who,whatPair[0])],this.players[who].hand[this.findCard(who,whatPair[0])+1],this.players[who].hand[this.findCard(who,11)]);
							decide = { what: cards, where: whatPair[0] };
						}
					}
				}
				break;
			}
			case "addWild": {
				if (this.findAmount(who,11) > 0) { 
					if (this.table[team][11].length > 0 && this.removeAndAble(who, 11, 11, 1)) {
						decide = { what: [this.players[who].hand[this.findCard(who,11)]], where: 11 };
					}
					else if (this.ableOut[team].wild && this.ableOut[team].red && !this.ableOut[team].black && this.players[who].foot.length == 0) {
						var best = -1;
						for (var i = 0; i < 11; i++) {
							if (this.table[team][i].length == 6) { best = i; }
						}
						if (best != -1 && this.removeAndAble(who, 11, best, 1)) { 
							decide = { what: [this.players[who].hand[this.findCard(who,11)]], where: best };
						}
					}
				}
				break;
			}
			case "dumpWildFoot": {
				if (this.players[who].foot.length == 0 && this.findAmount(who,11) > 0 && this.ableToGoOut(team) && this.cardsGoPlaces(who, team) < 2) {
					var best = -1;
					for (var i = 0; i < this.table[team].length; i++) {
						if (this.table[team][i].length > 0) { 
							if (best == -1) { best = i; }
							else {
								if (this.table[team][i].length > this.table[team][best].length) { best = i; }
							}
						}
					}
					if (best != -1) {
						cards.push(this.players[who].hand[this.findCard(who, 11)]);
						decide = { what: cards, where: best };
					}
				}
				break;
			}
			case "dumpWildHand": { 
				if (this.findAmount(who, 11) > 0 && this.players[who].foot.length > 0) {
					if (this.players[who].hand.length == this.findAmount(who,11) || (this.players[who].hand.length - 1) == this.findAmount(who,11)) {
						if (this.findAmount(who,11) >= 3 && this.table[team][11].length == 0) { //essientially creating 2nd wild card canasta.
							cards.push(this.players[who].hand[this.findCard(who,11)], this.players[who].hand[this.findCard(who,11)+1], this.players[who].hand[this.findCard(who,11)+2]);
							if (this.findAmount(who,11) > 3) {
								for (var j = 4; j < this.findAmount(who,11); j++) { cards.push(this.players[who].hand[this.findCard(who,11)+(j-1)]); }
							}
							decide = { what: cards, where: 11 };
						}
						else { //regardless should only be left with 2 wilds, max.
							var best = -1;
							for (var i = 0; i < this.table[team].length; i++) { //try to finish a meld
								if (this.table[team][i].length > 0) {
									if (this.table[team][i].length + this.findAmount(who,11) == 7) { best = i; }
								}
							}
							if (best != -1) { 
								for (var i = 0; i < this.findAmount(who,11); i++) { cards.push(this.players[who].hand[this.findCard(who,11)+i]); }
								decide = { what: cards, where: best };
							}
							else { //can't finish a meld, find a black one to add to.
								var best = -1; var haveMelds = [];
								for (var i = 0; i < this.table[team].length; i++) {
									if (this.table[team][i].length > 0) {
										haveMelds.push(i);
										for (var j = 0; j < this.table[team][i].length; j++) {
												if (this.cards[this.table[team][i][j]].card == 11) { best = i; }
										}
									}
								}
								if (best != -1) {
									for (var i = 0; i < this.findAmount(who,11); i++) { cards.push(this.players[who].hand[this.findCard(who,11)+i]); }
									decide = { what: cards, where: best };
								}
								else { //cant finish, can't add to already black, just dump it.
									var best = -1;
									if (haveMelds.length > 0) { best = getRandom(0,(haveMelds.length-1)); }
									if (best != -1) {
										for (var i = 0; i < this.findAmount(who,11); i++) { cards.push(this.players[who].hand[this.findCard(who,11)+i]); }
										decide = { what: cards, where: best };
									}
								}
								//no places to put wilds, discard one...
							}
						}
					}
				}
				break;
			}
		}
		if (cards.length > 0) { 
			this.log.write(option); 
			this.log.write(who + "-" + this.players[who].hand);
			this.log.write(cards);
		}
	}
	return decide;
}

_Canasta.prototype.cardsGoPlaces = function(who, team) { //returns # of cards that can't be placed
	var dontGo = 0;
	for (var i = 0; i < this.players[who].hand.length; i++) {
		var card = this.cards[this.players[who].hand[i]].card;
		if (card == 13) { dontGo++; }
		else {
			if (this.table[team][card].length == 0 && this.findAmount(who, card) == 1 && card != 11 && !this.canTuck(team, card)) { dontGo++; } //single can't tuck.
			else if (this.findAmount(who, card) == 2 && this.findAmount(who,11) == 0 && card != 11) { dontGo++; } //pair with no wilds available.
			else if (card == 11 && !this.meldsOnTable(team)) { dontGo++; } //wild card with nowhere to go
		}
	}
	
	var pairs = 0; var whatPair = [];
	for (var i = 0; i < 11; i++) {
		if (this.findAmount(who, i) == 2) { pairs++; whatPair.push(i); }
	}
	
	if (pairs > this.findAmount(who, 11)) {
		while (pairs > this.findAmount(who,11)) {
			pairs--; dontGo++; dontGo++;
		}
	}
	
	if (this.players[who].hand.length == 3 && this.cards[this.players[who].hand[0]].card == this.cards[this.players[who].hand[1]].card && this.cards[this.players[who].hand[2]].card == this.cards[this.players[who].hand[0]].card ) {
		if (this.table[team][this.cards[this.players[who].hand[0]].card].length == 0 && !this.canTuck(team,this.cards[this.players[who].hand[0]].card)) { dontGo++; dontGo++; dontGo++; }
	}
	
	return dontGo;
}

_Canasta.prototype.canTuck = function (team, card) { // T/F if a card can be tucked.
	var couldTuck = false;
	for (var i = 0; i < this.canastas[team].length; i++) {
		if (card == this.cards[this.canastas[team][i]].card) { couldTuck = true; }
	}
	return couldTuck;
}

_Canasta.prototype.meldsOnTable = function(team) { // T/F if team has any melds on table.
	var melds = false;
	for (var i = 0; i < this.table[team].length; i++) {
		if (this.table[team][i].length > 0) { melds = true; }
	}
	return melds;
}

_Canasta.prototype.findDiscard = function(who) {
	if (!this.aiLogic.discard) {
		var team = who == 2 ? 0 : 1;
		var otherTeam = team == 0 ? 1 : 0;
		var card = -1;
		if (this.findAmount(who, 13) > 0) {
			var card = this.players[who].hand[this.findCard(who,13)];
		} 
		else {
			var singles = [];
			var pairs = [];
			for (var i = 0; i < 11; i++) { 
				if (this.findAmount(who,i) == 1) { singles.push(i); }
				if (this.findAmount(who,i) == 2) { pairs.push(i); }
			}
			if (singles.length > 0) {
				if (this.melded[otherTeam]) {
					var found = false;
					for (var i = 0; i < this.table[otherTeam].length; i++) {
						if (this.table[otherTeam][i].length > 0) {
							for (var j = 0; j < singles.length; j++) {
								if (!found && this.cards[this.table[otherTeam][i][0]].card == singles[j]) { found = true; card = this.players[who].hand[this.findCard(who,singles[j])]; }
							}
						}
					}
					if (!found) { card = this.players[who].hand[this.findCard(who,singles[0])]; }
				}
				else { card = this.players[who].hand[this.findCard(who,singles[0])]; }
			}
			else if (pairs.length > 0) {
				if (this.melded[otherTeam]) {
					var found = false;
					for (var i = 0; i < this.table[otherTeam].length; i++) {
						if (this.table[otherTeam][i].length > 0) {
							for (var j = 0; j < pairs.length; j++) {
								if (!found && this.cards[this.table[otherTeam][i][0]].card == pairs[j]) { found = true; card = this.players[who].hand[this.findCard(who,pairs[j])]; }
							}
						}
					}
					if (!found) { card = this.players[who].hand[this.findCard(who,pairs[0])]; }
				}
				else { card = this.players[who].hand[this.findCard(who,pairs[0])]; }
			}
			else { //no singles, no pairs, no black threes... throw lowest card.
				var mistake = false;
				for (var i = 0; i < this.table[team].length; i++) {
					if (this.table[team][i].length > 0) { mistake = true; }
				}
				card = this.players[who].hand[0];
			}
		}
		if (card == -1) { Abort("didnt discard: "+ this.players[who].hand); }
		this.animateList.push(new _animate([this.players[who].x],[this.players[who].y],[this.discardPile.x],[this.discardPile.y],[card],"aiDiscard",this.animateLength,1,who,"done"));
		this.removeCard(who,card);
		this.phase = "wait";
	}
}

_Canasta.prototype.red3 = function(who) {
	var have = false;
	for (var i = 0; i < this.players[who].hand.length; i++) {
		if (this.cards[this.players[who].hand[i]].card == 12) { have = true; }
	}
	return have;
}

_Canasta.prototype.findRed3 = function(who) {
	var location = -1;
	for (var i = 0; i < this.players[who].hand.length; i++) {
		if (this.cards[this.players[who].hand[i]].card == 12) { location = i; break; }
	}
	if (location == -1) { Abort("no red3 found"); }
	return location;
}

_Canasta.prototype.removeCard = function(who, what) { //actual 0-53
	var where = -1;
	for (var i = 0; i < this.players[who].hand.length; i++) {
		if (this.players[who].hand[i] == what) { where = i; }
	}
	if (where == -1) { Abort("removeCard error"); }
	else { this.players[who].hand.splice(where, 1); }
}

_Canasta.prototype.ableToGoOut = function(team) {
	if (this.ableOut[team].wild && this.ableOut[team].black && this.ableOut[team].red) { return true; }
	else { return false; }
}

_Canasta.prototype.userTurn = function() {
	this.keys.mouse = [];
	switch(this.phase) {
		case "draw": {
			if (this.stock.cards.length > 0) { this.keys.mouse.push(new _mouse(this.stock.x, this.stock.y, this.game.cardWidth, this.game.cardHeight, "stock", true)); }
			this.keys.mouse.push(new _mouse(this.discardPile.x, this.discardPile.y, this.game.cardWidth, this.game.cardHeight, "discards", true));
			break;
		}
		case "discards":
		case "play": {
			var pos = this.players[0].hand.length * 7.5;
			for (var i = 0; i < this.players[0].hand.length; i++) {
				if (i == (this.players[0].hand.length - 1)) { var width = this.game.cardWidth; }
				else { var width = 15; }
				this.keys.mouse.push(new _mouse(((this.players[0].x - pos) + (i * 15)), this.players[0].y, width, this.game.cardHeight, this.cards[this.players[0].hand[i]].card, true, i));
			}
			break;
		}
		case "wild": {
			for (var i = 0; i < this.table[0].length; i++) {
				if (i == (this.table[0].length - 1)) { var width = this.game.cardWidth; }
				else { var width = 15; }
				var y = (this.table[0][i].length * this.team[0].meldY) + this.team[0].tableY; //next card to be placed
				this.keys.mouse.push(new _mouse( (this.team[0].tableX + (i * this.team[0].meldX)), y, width, this.game.cardHeight, "wild", true, i));
			}
			break;
		}
	}
}

_Canasta.prototype.animate = function() { 
	this.animateList[0].timer++;
	if (this.animateList[0].timer < this.animateList[0].timerLength) {
		for (var i = 0; i < this.animateList[0].image.length; i++) {
			var x = this.animateList[0].x[i] + ((this.animateList[0].xST[i]/this.animateList[0].timerLength)*this.animateList[0].timer);
			var y = this.animateList[0].y[i] + ((this.animateList[0].yST[i]/this.animateList[0].timerLength)*this.animateList[0].timer);
			if (this.animateList[0].image[i] == undefined) { this.log.write("undefined: "+this.animateList[0].image+"--"+this.players[this.turn].hand+"-"+this.animateList[0].action+","+this.animateList[0].team+","+this.animateList[0].nextPhase+":" +x+","+y); }
			if (this.animateList[0].image[i] == 99 || this.animateList[0].action == "aiHand") { this.backGraphic.blit(x, y); }
			else { 
				if (this.turn == 0 || this.turn == 2 || this.animateList[0].action == "aiDiscard") {
					this.cards[this.animateList[0].image[i]].image.blit(x, y); 
				}
				else { this.cards[this.animateList[0].image[i]].hor.blit(x, y); }
			}
		}
	}
	else {
		switch(this.animateList[0].action) {
			case "aiDiscard": {
				this.discardPile.cards.unshift(this.animateList[0].image[0]);
				if (this.players[this.animateList[0].team].hand.length == 0) {
					if (this.players[this.animateList[0].team].foot.length > 0) {
						for (var i = 0; i < this.players[this.animateList[0].team].foot.length; i++) {
							this.players[this.animateList[0].team].hand.push(this.players[this.animateList[0].team].foot[i]);
						}
						this.players[this.animateList[0].team].hand.sort(compareNumbers);
						this.players[this.animateList[0].team].foot = [];
					}
					else {
						//hand over... 
						this.changeHand(this.players[this.animateList[0].team].team);
						this.phase = "finishHand";
					}
				}
				if (this.animateList.length == 1 && this.phase != "finishHand") { this.phase = "done"; }
				break;
			}
			case "aiRed3": {
				this.redThree[this.animateList[0].team]++;
				this.canastaPoints[this.animateList[0].team][this.currentHand] += 100;
				if (this.animateList.length == 1) { this.phase = ""; }
				break;
			}
			case "aiTable": {
				for (var i = 0; i < this.animateList[0].iterations; i++) { this.toTable(this.players[this.animateList[0].team].team, this.cards[this.animateList[0].image[i]].card, this.animateList[0].image[i]); }
				this.checkCanasta(this.players[this.animateList[0].team].team);
				if (this.animateList[0].nextPhase != "aiDiscardPile" && this.players[this.turn].hand.length == 0) {
					if (this.players[this.turn].foot.length > 0) {
						for (var i = 0; i < this.players[this.turn].foot.length; i++) {
							this.players[this.turn].hand.push(this.players[this.turn].foot[i]);
						}
						this.players[this.turn].hand.sort(compareNumbers);
						this.players[this.turn].foot = [];
					}
					this.phase = "";
				}
				else if (this.animateList[0].nextPhase == "aiDiscardPile") {
					var who = this.animateList[0].team;
					var pos = this.discardPile.cards.length * 7.5;
					var pile = { x: [], y: [], x2: [], y2: [], card: [] };
					for (var i = 0; i < this.discardPile.cards.length; i++) {
						this.players[who].team == 0 ? (pile.x2.push((this.players[who].x-pos)+(i*35)), pile.y2.push(this.players[who].y)) : (pile.y2.push((this.players[who].y-pos)+(i*15)), pile.x2.push(this.players[who].x));
						pile.x.push(this.discardPile.x); pile.y.push(this.discardPile.y);
						pile.card.push(this.discardPile.cards[i]); 
					}
					this.animateList.push(new _animate(pile.x,pile.y,pile.x2,pile.y2,pile.card,"aiHand",this.animateLength,this.discardPile.cards.length,who,"wait"));
					this.discardPile.cards = [];
				}
				if (this.animateList.length == 1) { this.phase = ""; }
				break;
			}
			case "aiPlayTable": {
				if (this.animateList[0].extra != "tuck") {
					for (var i = 0; i < this.animateList[0].iterations; i++) { this.toTable(this.animateList[0].team, this.animateList[0].extra, this.animateList[0].image[i]); }
					this.checkCanasta(this.animateList[0].team);
				}
				else { this.cardPoints[this.animateList[0].team][this.currentHand] += this.cards[this.animateList[0].image[0]].value; }
				if (this.players[this.turn].hand.length == 0) {
					if (this.players[this.turn].foot.length > 0) {
						for (var i = 0; i < this.players[this.turn].foot.length; i++) {
							this.players[this.turn].hand.push(this.players[this.turn].foot[i]);
						}
						this.players[this.turn].hand.sort(compareNumbers);
						this.players[this.turn].foot = [];
					}
				}
				if (this.animateList.length == 1) { this.phase = ""; }
				break;
			}
			case "aiHand": {
				for (var i = 0; i < this.animateList[0].image.length; i++) { this.players[this.animateList[0].team].hand.push(this.animateList[0].image[i]); }
				this.players[this.animateList[0].team].hand.sort(compareNumbers);
				if (this.animateList.length == 1) { this.phase = ""; }
				break;
			}
			case "aiCanasta": {
				this.canastas[this.animateList[0].team].push(this.animateList[0].image[0]);
				this.phase = "";
				break;
			}
			case "canasta": {
				this.canastas[0].push(this.animateList[0].image[0]);
				break;
			}
			case "tuck": {
				this.cardPoints[0][this.currentHand] += this.cards[this.animateList[0].image[0]].value;
				break;
			}
			case "discard": {
				this.discardPile.cards.unshift(this.animateList[0].image[0]);
				break;
			}
			case "hand": {
				for (var i = 0; i < this.animateList[0].image.length; i++) { this.players[0].hand.push(this.animateList[0].image[i]); }
				break;
			}
			case "table": {
				for (var i = 0; i < this.animateList[0].image.length; i++) { this.toTable(0, this.cards[this.animateList[0].image[i]].card, this.animateList[0].image[i]); }
				break;
			}
			case "red3": {
				this.redThree[0]++; break;
			}
		}
		this.players[this.turn].hand.sort(compareNumbers);
		this.animateList.shift();
		if (this.animateList.length == 0 && this.turn == 0) { this.checkCanasta(0); }
	}
}

_Canasta.prototype.reset = function() {
	this.discardPile.cards = [];
	for (var i = 0; i < this.players.length; i++) {
		this.players[i].hand = [];
		this.players[i].foot = [];
	}
	this.table = [ [],[] ];
		for (var i = 0; i < 12; i++) {
			this.table[0][i] = []; this.table[1][i] = [];
		}
		this.canastas = [ [], [] ];
		this.redThree = [ [], [] ];
	this.melded = [false, false];
	this.animateList = [];
	this.ableOut = [];
		this.ableOut[0] = { wild: false, red: false, black: false };
		this.ableOut[1] = { wild: false, red: false, black: false };
		
	this.shuffle();
}

_Canasta.prototype.changeHand = function(last) {
	if (last != -1) { this.canastaPoints[last][this.currentHand] += 100; } //going out bonus...
	if (this.canastas[0].length == 0) { //go backwards...
		var x = -1; 
		this.canastaPoints[0][this.currentHand] *= x;
	} 
	else { var x = 1; }
	for (var i = 0; i < this.players[0].hand.length; i++) { this.cardPoints[0][this.currentHand] -= this.cards[this.players[0].hand[i]].value; }
	for (var i = 0; i < this.players[0].foot.length; i++) { this.cardPoints[0][this.currentHand] -= this.cards[this.players[0].foot[i]].value; }
	for (var i = 0; i < this.players[2].hand.length; i++) { this.cardPoints[0][this.currentHand] -= this.cards[this.players[2].hand[i]].value; }
	for (var i = 0; i < this.players[2].foot.length; i++) { this.cardPoints[0][this.currentHand] -= this.cards[this.players[2].foot[i]].value; }
	for (var i = 0; i < this.table[0].length; i++) { 
		for (var j = 0; j < this.table[0][i].length; j++) { this.cardPoints[0][this.currentHand] += this.cards[this.table[0][i][j]].value * x; }
	}
	
	if (this.canastas[1].length == 0) { var x = -1; } //go backwards...
	else { var x = 1; }
	for (var i = 0; i < this.players[1].hand.length; i++) { this.cardPoints[1][this.currentHand] -= this.cards[this.players[1].hand[i]].value; }
	for (var i = 0; i < this.players[1].foot.length; i++) { this.cardPoints[1][this.currentHand] -= this.cards[this.players[1].foot[i]].value; }
	for (var i = 0; i < this.players[3].hand.length; i++) { this.cardPoints[1][this.currentHand] -= this.cards[this.players[3].hand[i]].value; }
	for (var i = 0; i < this.players[3].foot.length; i++) { this.cardPoints[1][this.currentHand] -= this.cards[this.players[3].foot[i]].value; }
	for (var i = 0; i < this.table[1].length; i++) { 
		for (var j = 0; j < this.table[1][i].length; j++) { this.cardPoints[1][this.currentHand] += this.cards[this.table[1][i][j]].value * x; }
	}
	this.points[0][this.currentHand] = this.canastaPoints[0][this.currentHand] + this.cardPoints[0][this.currentHand];
	this.points[1][this.currentHand] = this.canastaPoints[1][this.currentHand] + this.cardPoints[1][this.currentHand];
	if (this.currentHand != 0) {
		this.points[0][this.currentHand] += this.points[0][(this.currentHand-1)];
		this.points[1][this.currentHand] += this.points[1][(this.currentHand-1)];
	}                                   
}

_Canasta.prototype.toTable = function(team, where, what) {
	this.table[team][where].push(what);
}

_Canasta.prototype.checkCanasta = function(team) {
	for (var i = 0; i < this.table[team].length; i++) {
		if (this.table[team][i].length > 6) {
			var face = -1; var black = false; var points = 0;
			if (i == 11) { //wild canasta
				face = this.table[team][11][6]; points = 1500;
				this.ableOut[team].wild = true;
			}
			else { //4 - Ace...
				for (var j = 0; j < this.table[team][i].length; j++) {
					if (this.cards[this.table[team][i][j]].card == 11) { black = true; }
				}
				if (black) { //found a wild
					for (var j = 0; j < this.table[team][i].length; j++) { 
						if (face == -1 && this.cards[this.table[team][i][j]].isBlack) { face = this.table[team][i][j]; }
					}
					if (face == -1) { //only red cards in canasta.
						//face = this.table[team][i][0] + 1; 
						for (var j = 0; j < this.table[team][i].length; j++) {
							if (this.cards[this.table[team][i][j]].card == i) { face = this.table[team][i][j] + 1; break; }
						}
					} 
					points = 300;
					this.ableOut[team].black = true;
				}
				else { //red canasta...
					for (var j = 0; j < this.table[team][i].length; j++) {
						if (face == -1 && !this.cards[this.table[team][i][j]].isBlack) { face = this.table[team][i][j]; }
					}
					if (face == -1) { face = this.table[team][i][0] - 1; } //only black cards in canasta
					points = 500;
					this.ableOut[team].red = true;
				}
			}
			if (team == 0) { var pile = { x1:  ((i * this.team[0].meldX) + this.team[0].tableX), x2: ((this.canastas[0].length * 25) + this.team[0].canastaX), y: this.team[0].tableY, y2: this.team[0].canastaY }; }
			else { var pile = { x1: this.team[1].tableX, x2: this.team[1].canastaX, y: ((i * this.team[1].meldY) + this.team[1].tableY), y2: this.team[1].canastaY - (this.canastas[1].length * 20) }; }
			if (this.turn == 0) { this.animateList.push(new _animate([pile.x1],[pile.y],[pile.x2],[pile.y2],[face],"canasta",this.animateLength,1)); }
			else { this.animateList.push(new _animate([pile.x1],[pile.y],[pile.x2],[pile.y2],[face],"aiCanasta",this.animateLength,1,team)); }
			this.canastaPoints[team][this.currentHand] += points;
			for (var j = 0; j < this.table[team][i].length; j++) { this.cardPoints[team][this.currentHand] += this.cards[this.table[team][i][j]].value; }
			this.table[team][i] = [];
		}
	}
}

_Canasta.prototype.findCard = function(who, card) { //card type 0 - 13
	if (who == undefined) { who = 0; }
	var location = -1;
	for (var i = 0; i < this.players[who].hand.length; i++) {
		if (location == -1 && this.cards[this.players[who].hand[i]].card == card) {
			location = i;
		}
	}
	if (location != -1) { return location; }
	else { Abort("card not found"); }
}

_Canasta.prototype.findAmount = function(who, card) { //card type 0 -13
	var amount = 0;
	for (var i = 0; i < this.players[who].hand.length; i++) {
		if (this.cards[this.players[who].hand[i]].card == card) { amount++; }
	}
	return amount;
}

_Canasta.prototype.checkMeldPoints = function() {
	var points = 0;
	for (var i = 0; i < this.table[0].length; i++) {
		if (this.table[0][i].length > 2) {
			for (var j = 0; j < this.table[0][i].length; j++) {
				points += this.cards[this.table[0][i][j]].value;
			}
		}
	}
	if (points >= this.hands[this.currentHand]) { return true; }
	else { return false; }
}

_Canasta.prototype.checkAiMeldPoints = function(who) {
	var amount = [0,0,0,0,0 ,0,0,0,0,0, 0,0];
	var location = [-1,-1,-1,-1,-1, -1,-1,-1,-1,-1, -1,-1];
	for (var i = 0; i < this.players[who].hand.length; i++) {
		if (this.cards[this.players[who].hand[i]].card < 12) {
			amount[this.cards[this.players[who].hand[i]].card]++;
			if (location[this.cards[this.players[who].hand[i]].card] == -1) { location[this.cards[this.players[who].hand[i]].card] = i; }
		}
	}
	var points = 0;
	for (var i = 0; i < amount.length; i++) {
		if (amount[i] > 2) { 
			for (var j = 0; j < amount[i]; j++) { points += this.cards[this.players[who].hand[location[i]+j]].value; }
		}
	}
	
	return [points, amount, location];
}

_Canasta.prototype.removeAndAble = function(who, what, where, howMany) {
	var team = 0;
	if (who == 1 || who == 3) { team = 1; }
	if (this.players[who].foot.length > 0) { return true; }
	else {
		if ((this.players[who].hand.length - howMany) > 1) { return true; }
		else if ((this.players[who].hand.length - howMany) <= 0) { return false; }
		else { //leaving only a single card in hand, to discard..
			if (this.ableOut[team].wild && this.ableOut[team].red && this.ableOut[team].black) { return true; }
			else {
				if (this.ableOut[team].wild && this.ableOut[team].red && where != 11) {
					if (this.table[team][where].length + howMany >= 7) { 
						var makingBlack = false;
						for (var i = 0; i < this.table[team][where].length; i++) {
							if (this.cards[this.table[team][where][i]].card == 11) { makingBlack = true; }
						}
						if (what == 11) { makingBlack = true; }
						return makingBlack;
					}
				}
				else if (this.ableOut[team].wild && this.ableOut[team].black  && what != 11) {
					if (this.table[team][where].length + howMany >= 7) {
						var noWildFound = true;
						for (var i = 0; i < this.table[team][where].length; i++) {
							if (this.cards[this.table[team][where][i]].card == 11) { noWildFound = false; }
						}
						return noWildFound;
					}
				}
				else if (this.ableOut[team].black && this.ableOut[team].red && what == 11 && where == 11) {
					if (this.table[team][11].length + howMany >= 7) { return true; }
					else { return false; }
				}
				else { return false; }
			}
		}
	}
}

_Canasta.prototype.showScore = function() {
	var x = 195; var y = 195; var w = 500; var h = 195; //195, 195, 308
	Rectangle(x,y,w,h,this.color.black);
	this.font.setColorMask(this.color.white); this.font.drawText(x + 9, y + 5, "Hand")
	this.font.setColorMask(this.color.lightGreen);
	this.font.drawText(x + 40 + ((w-40)/4) - (this.font.getStringWidth("North & South")/2), y + 5, "North & South"); //500 - 40
	this.font.drawText(x + 40 + ((w-40)/2) + ((w-40)/4) - (this.font.getStringWidth("East & West")/2), y + 5, "East & West");
	Line(x + 2,y + 16,x + 305 + (w - 308), y + 16,this.color.grey);
	this.font.setColorMask(this.color.orange); this.font.drawText(x + 15, y + 30, "50");
	Line(x + 2,y + 53, x + 305 + (w - 308),y + 53,this.color.grey); this.font.drawText(x + 15, y + 65, "90");
	Line(x + 2,y + 88, x + 305 + (w - 308),y + 88,this.color.grey); this.font.drawText(x + 10, y + 100, "120");
	Line(x + 2,y + 123,x + 305 + (w - 308),y + 123,this.color.grey); this.font.drawText(x + 10, y + 135, "150");
	Line(x + 2,y + 158,x + 305 + (w - 308),y + 158,this.color.grey); this.font.drawText(x + 10, y + 170, "200");
	Line(x + 2,y + 2,  x + 2,			   y + 192,this.color.grey); Line(x + 2,y + 2,x + 305 + (w - 308),y + 2,this.color.grey);
	Line(x + 2,y + 192,x + 305 + (w - 308),y + 192,this.color.grey); Line(x + 40,y + 2,x + 40,y + 192,this.color.grey);
	Line(x + 172 + (w - 308)/2,y + 2,x + 172 + (w - 308)/2,y + 192,this.color.grey); Line(x + 305 + (w - 308),y + 2,x + 305 + (w - 308),y + 192,this.color.grey);
	this.font.setColorMask(this.color.white);
	for (var i = 0; i < this.canastaPoints.length; i++) {
		for (var j = 0; j < (this.currentHand + 1); j++) {
			this.font.drawText(x + ((w-40)/2) - 10 + (i*((w-40)/2)) - this.font.getStringWidth(this.canastaPoints[i][j]), y + 20 + (j * 35), this.canastaPoints[i][j]);
			this.font.drawText(x + ((w-40)/2) - 10 + (i*((w-40)/2)) - this.font.getStringWidth(this.cardPoints[i][j]), y + 30 + (j* 35), this.cardPoints[i][j]);
			this.font.drawText(x + ((w-40)/2) - 10 + (i*((w-40)/2)) - this.font.getStringWidth(this.points[i][j]), y + 40 + (j * 35), this.points[i][j]);
			Line(x + ((w-40)/2) - 10 + (i*((w-40)/2)) - 70, y + 38 + (j*35), x + ((w-40)/2) - 10 + (i*((w-40)/2)), y + 38 + (j*35), this.color.yellow);
		}
	}
}

_Canasta.prototype.burnWild = function() {
	var x = GetMouseX(); var y = GetMouseY(); var found = false;
	for (var i = 0; i < this.keys.mouse.length; i++) {
		if (x > this.keys.mouse[i].x && x < this.keys.mouse[i].x2 && y > this.keys.mouse[i].y && y < this.keys.mouse[i].y2) {
			this.cards[this.animateExtra].image.blit(this.keys.mouse[i].x, this.keys.mouse[i].y); found = true;
		}
		if (!found) { this.cards[this.animateExtra].image.blit(x, y); }
	}
}

_Canasta.prototype.showArrow = function() {
	switch(this.turn) { //444, 250, 504, 250
		case 0: { Triangle(435,345,563,345,499,380,this.color.yellow2); break; } //this.arrow.rotateBlit(474, 490, 1.57); break; }
		case 1: { Triangle(435,225,435,345,400,285,this.color.yellow2); break; }//this.arrow.rotateBlit(280, 370, 3.14); break; }
		case 2: { Triangle(435,225,563,225,499,190,this.color.yellow2); break; }//this.arrow.rotateBlit(474, 250, -1.57); break; }
		case 3: { Triangle(563,225,563,345,598,285,this.color.yellow2); break; }
	}
}

_Canasta.prototype.userHand = function() {
	var x = GetMouseX(); var y = GetMouseY(); var handWidth = this.players[0].hand.length * 7.5;
	this.highLight = { card: -1, indicate: -1 }; var tint = [];
	for (var i = 0; i < this.players[0].hand.length; i++) {
		var end = 0; if (i == (this.players[0].hand.length - 1)) { end = this.game.cardWidth; }
		if (x > (this.players[0].x - handWidth  + (i * 15)) && x < ((this.players[0].x+15) - handWidth + (i * 15) + end) && y > this.players[0].y && y < (this.players[0].y + this.game.cardHeight)) {
			this.highLight.indicate = i; this.highLight.card = this.cards[this.players[0].hand[i]].card;
		}
	}
	for (var i = 0; i < this.players[0].hand.length; i++) {
		this.cards[this.players[0].hand[i]].image.blit(this.players[0].x - handWidth + (i * 15), this.players[0].y);
		if (this.turn == 0 && (this.phase == "play" || this.phase == "discards")) {
			if (this.keys.shift && this.highLight.card == this.cards[this.players[0].hand[i]].card && this.highLight.card < 12 && this.highLight.indicate != i && !IsKeyPressed(KEY_ALT)) {
				this.cards[this.players[0].hand[i]].image.blitMask(this.players[0].x - handWidth + (i *15), this.players[0].y, this.color.shiftTint);
			}
			else if (this.highLight.indicate == i) { 
				if (!IsKeyPressed(KEY_ALT)) { this.cards[this.players[0].hand[i]].image.blitMask(this.players[0].x-handWidth+(i*15), this.players[0].y ,this.color.indicateTint); }
				else { this.cards[this.players[0].hand[i]].image.blitMask(this.players[0].x-handWidth+(i*15), this.players[0].y,this.color.redTint); }
			}
		}
	}
}

_Canasta.prototype.showTable = function() {
	if (this.stock.cards.length > 0) { this.backGraphic.blit(this.stock.x, this.stock.y); } //444, 364 --- 504, 364
	this.font.drawText((this.stock.x+25) - (this.font.getStringWidth("( "+this.stock.cards.length+" )")/2), this.stock.y+this.game.cardHeight+10, "( "+this.stock.cards.length+" )");
	if (this.discardPile.cards.length > 0) { this.cards[this.discardPile.cards[0]].image.blit(this.discardPile.x, this.discardPile.y); }
	this.font.drawText((this.discardPile.x+25) - (this.font.getStringWidth("( "+this.discardPile.cards.length+" )")/2), this.discardPile.y+this.game.cardHeight+10, "( "+this.discardPile.cards.length+" )");
	if (!this.melded[0] || !this.melded[1]) { 
		var text = this.hands[this.currentHand] + " points to meld.";
		this.font.drawText((this.discardPile.x-4) - (this.font.getStringWidth(text)/2), this.stock.y + 135, text); //380-250 130.
	}
	if (this.turn == 0 && this.phase == "discards") {
		var text = "Press ALT when done attempting to meld.";
		this.font.drawText(499 - (this.font.getStringWidth(text)/2), this.stock.y + 155, text); 
	}
	for (var i = 0; i < this.table[0].length; i++) { //north & south
		if (this.table[0][i].length > 0) { 
			for (var j = 0; j < this.table[0][i].length; j++) { this.cards[this.table[0][i][j]].image.blit(this.team[0].tableX + (i * this.team[0].meldX), this.team[0].tableY + (j * this.team[0].meldY)); }
		}
	}
	for (var i = 0; i < this.canastas[0].length; i++) { this.cards[this.canastas[0][i]].image.blit(this.team[0].canastaX + (i * 25), this.team[0].canastaY); }
	if (this.redThree[0] > 0) { this.cards[52].image.blit(this.team[0].red3X, this.team[0].red3Y); }
	var handWidth = this.players[2].hand.length * 7.5;
	//for (var i = 0; i < this.players[2].hand.length; i++) { this.cards[this.players[2].hand[i]].image.blit(this.players[2].x - handWidth + (i * 15), this.players[2].y); }
	for (var i = 0; i < this.players[2].hand.length; i++) { this.backGraphic.blit(this.players[2].x - handWidth + (i * 15), this.players[2].y); }
	if (this.players[0].foot.length > 0) {
		this.backGraphic.rotateBlit(880, 600, DegreesToRadians(-45)); Rectangle(870, 630, 76, 12, this.color.black);
		this.font.drawText(873, 632, " Your Foot");
	}
	if (this.players[2].foot.length > 0) {
		this.backGraphic.rotateBlit(75, 20, DegreesToRadians(-45)); Rectangle(65, 50, 76, 12, this.color.black);
		this.font.drawText(68, 52, "North's Foot");
	}
	if (this.players[1].foot.length > 0) {
		this.backGraphic.rotateBlit(35, 70, DegreesToRadians(-45)); Rectangle(25, 100, 76, 12, this.color.black);
		this.font.drawText(28, 102, "West's Foot");
	}
	if (this.players[3].foot.length > 0) {
		this.backGraphic.rotateBlit(920, 550, DegreesToRadians(-45)); Rectangle(910, 580, 76, 12, this.color.black);
		this.font.drawText(913, 582, "East's Foot");
	}
	
	for (var i = 0; i < this.table[1].length; i++) { //east & west
		if (this.table[1][i].length > 0) { 
			for (var j = 0; j < this.table[1][i].length; j++) { this.cards[this.table[1][i][j]].hor.blit(this.team[1].tableX + (j*this.team[1].meldX), this.team[1].tableY +(i * this.team[1].meldY)); }
		}
	}
	for (var i = 0; i < this.canastas[1].length; i++) { this.cards[this.canastas[1][i]].hor.rotateBlit(this.team[1].canastaX, this.team[1].canastaY - (i*25), DegreesToRadians(180)); }
	if (this.redThree[1] > 0) { this.cards[52].hor.rotateBlit(this.team[1].red3X, this.team[1].red3Y, DegreesToRadians(180)); }
	var handWidth = this.players[1].hand.length * 7.5; //west
	for (var i = 0; i < this.players[1].hand.length; i++) { this.backGraphicHor.blit(this.players[1].x - this.game.cardHeight, this.players[1].y - handWidth + (i *15)); }
	var handWidth = this.players[3].hand.length * 7.5; //east
	for (var i = this.players[3].hand.length-1; i > -1; i--) { this.backGraphicHor.rotateBlit(this.players[3].x, this.players[3].y - handWidth + (i *15), DegreesToRadians(180)); }
}

_Canasta.prototype.checkPair = function(who) {
	var pair = false;
	if (!this.cards[this.discardPile.cards[0]].freeze) {
		var like = 0;
		for (var i = 0; i < this.players[who].hand.length; i++) {
			if (this.cards[this.players[who].hand[i]].card == this.cards[this.discardPile.cards[0]].card) { like++; }
		}
		if (like >= 2) { pair = true; }
	}
	
	return pair;
}

_Canasta.prototype.shuffle = function() {
	this.stock.cards = [];
	var pendingCard; var duplicate = false;
	
	while (this.stock.cards.length != 270) {
		duplicate = false; 
		pendingCard = Math.floor(Math.random() * 270);
		for (var x = 0; x < this.stock.cards.length; x++) {
			if (pendingCard == this.stock.cards[x]) { duplicate = true; }
		}
		if (!duplicate) { this.stock.cards.push(pendingCard); }
	}
	//shuffled deck
	for (var i = 0; i < this.stock.cards.length; i++) {
		if (this.stock.cards[i] > 53 && this.stock.cards[i] < 108) { this.stock.cards[i] -= 54; }
		if (this.stock.cards[i] > 107 && this.stock.cards[i] < 162) { this.stock.cards[i] -= 108; }
		if (this.stock.cards[i] > 161 && this.stock.cards[i] < 216) { this.stock.cards[i] -= 162; }
		if (this.stock.cards[i] > 215) { this.stock.cards[i] -= 216; }
	}
	//divided into 5 decks
	for (var i = 0; i < 13; i++) {
		for (var j = 0; j < this.players.length; j++) {
			this.players[j].hand.push(this.stock.cards.pop());
			this.players[j].foot.push(this.stock.cards.pop());
			this.players[j].hand.sort(compareNumbers);
			this.players[j].foot.sort(compareNumbers);
		}
	}
	
	this.discardPile.cards.push(this.stock.cards.pop());
}

function _setCards() {
	var count = 0; var cardUP = 0;
	var value = 5; var black = false;
	var cards = [];
	cards.push(new _card(count,"0",13,5,false, true));
	count++;
	cards.push(new _card(count,"1",13,5,false, true));
	count++;
	for (var x = 2; x < 52; count++, x++) {
		var freeze = false; var black = true;
		var a = (count - 2) % 4;
		if (a == 0 && x < 50 && x > 5) { cardUP++; }
		if (cardUP > 3 && cardUP < 10) { value = 10; }
		if (cardUP == 10) { value = 20; }
		if (count < 50 && count > 45) { value = 20; }
		if (count == 50 || count == 51) { value = 50; cardUP = 11; }
		if ((x % 2) == 0 || x > 45) { black = false; }
		if (x > 45) { freeze = true; }
		cards.push(new _card(count, x, cardUP, value, black, freeze));
	}
	count++;
	cards.push(new _card(count,"52",12,100,false, true));
	count++;
	cards.push(new _card(count,"53",12,100,false, true));
	return cards;
}

function _card(index, image, card, value, black, freeze) {
	this.index = index;
	this.image = LoadImage(image +".png");
	this.hor = LoadImage("sideways/" + image + ".png");
	this.card = card;
	this.value = value;
	this.isBlack = black;
	if (freeze == undefined) { this.freeze = false; }
	else { this.freeze = freeze; }
}

function _animate(x, y, x2, y2, image, action, time, iterations, team, nextPhase, extra) {
	this.x = []; this.y = []; this.x2 = []; this.y2 = [];
	this.image = []; this.action = action;
	this.xST = []; this.yST = [];
	this.timer = 0; this.iterations = iterations;
	this.team = team; 
	this.nextPhase = nextPhase;
	this.timerLength = time;
	if (extra != undefined) { this.extra = extra; }
	for (var i = 0; i < x.length; i++) {
		this.x.push(x[i]); this.y.push(y[i]);
		this.x2.push(x2[i]); this.y2.push(y2[i]);
		this.image.push(image[i]);
		this.xST.push((x2[i] - x[i]));
		this.yST.push((y2[i] - y[i]));
	}
}

function _mouse(x, y, w, h, id, on, extra) {
	this.x = x; this.y = y; 
	this.w = w; this.h = h;
	if (on == undefined) { this.on = true; }
	else { this.on = on; }
	this.id = id; this.call;
	this.extra = extra;
	this.x2 = x + w; this.y2 = y + h;
}

function getRandom(min, max) {  
  return Math.floor(Math.random() * (max - min + 1)) + min;  
}

function compareNumbers(a, b) {
  if(a > b) { return 1; }
  if(a < b) { return -1; }
  return 0;
}